#include "stmflash.h"
#include "delay.h"

#define FLASH_SAVE_ADDR  0X0800E000 	//FLASH ַ(ΪżֵҪڱռFLASHĴС+0X08000000)
//STM32FLASH
void STMFLASH_Unlock(void)
{
  FLASH->KEYR=FLASH_KEY1;//д.
  FLASH->KEYR=FLASH_KEY2;
}
//flash
void STMFLASH_Lock(void)
{
  FLASH->CR|=1<<7;//
}
//õFLASH״̬
u8 STMFLASH_GetStatus(void)
{	
	u32 res;		
	res=FLASH->SR; 
	if(res&(1<<0))return 1;		    //æ
	else if(res&(1<<2))return 2;	//̴
	else if(res&(1<<4))return 3;	//д
	return 0;						//
}
//ȴ
//time:Ҫʱĳ
//ֵ:״̬.
u8 STMFLASH_WaitDone(u16 time)
{
	u8 res;
	do
	{
		res=STMFLASH_GetStatus();
		if(res!=1)break;//æ,ȴ,ֱ˳.
		delay_us(1);
		time--;
	 }while(time);
	 if(time==0)res=0xff;//TIMEOUT
	 return res;
}
//ҳ
//paddr:ҳַ
//ֵ:ִ
u8 STMFLASH_ErasePage(u32 paddr)
{
	u8 res=0;
	res=STMFLASH_WaitDone(0X5FFF);//ȴϴβ,>20ms    
	if(res==0)
	{ 
		FLASH->CR|=1<<1;//ҳ
		FLASH->AR=paddr;//ҳַ 
		FLASH->CR|=1<<6;//ʼ		  
		res=STMFLASH_WaitDone(0X5FFF);//ȴ,>20ms  
		if(res!=1)//æ
		{
			FLASH->CR&=~(1<<1);//ҳ־.
		}
	}
	return res;
}
//FLASHַָд
//faddr:ַָ(˵ַΪ2ı!!)
//dat:Ҫд
//ֵ:д
u8 STMFLASH_WriteHalfWord(u32 faddr, u16 dat)
{
	u8 res;	   	    
	res=STMFLASH_WaitDone(0XFF);	 
	if(res==0)//OK
	{
		FLASH->CR|=1<<0;//ʹ
		*(vu16*)faddr=dat;//д
		res=STMFLASH_WaitDone(0XFF);//ȴ
		if(res!=1)//ɹ
		{
			FLASH->CR&=~(1<<0);//PGλ.
		}
	} 
	return res;
} 
//ȡַָİ(16λ) 
//faddr:ַ 
//ֵ:Ӧ.
u16 STMFLASH_ReadHalfWord(u32 faddr)
{
	return *(vu16*)faddr; 
}
#if STM32_FLASH_WREN	//ʹд   
//д
//WriteAddr:ʼַ
//pBuffer:ָ
//NumToWrite:(16λ)   
void STMFLASH_Write_NoCheck(u32 WriteAddr,u16 *pBuffer,u16 NumToWrite)   
{ 			 		 
	u16 i;
	for(i=0;i<NumToWrite;i++)
	{
		STMFLASH_WriteHalfWord(WriteAddr,pBuffer[i]);
	    WriteAddr+=2;//ַ2.
	}  
} 
//ַָʼдָȵ
//WriteAddr:ʼַ(˵ַΪ2ı!!)
//pBuffer:ָ
//NumToWrite:(16λ)(Ҫд16λݵĸ.)
#if STM32_FLASH_SIZE<256
#define STM_SECTOR_SIZE 1024 //ֽ
#else 
#define STM_SECTOR_SIZE	2048
#endif		 
u16 STMFLASH_BUF[STM_SECTOR_SIZE/2];//2Kֽ
void STMFLASH_Write(u32 WriteAddr,u16 *pBuffer,u16 NumToWrite)	
{
	u32 secpos;	   //ַ
	u16 secoff;	   //ƫƵַ(16λּ)
	u16 secremain; //ʣַ(16λּ)	   
 	u16 i;    
	u32 offaddr;   //ȥ0X08000000ĵַ
	if(WriteAddr<STM32_FLASH_BASE||(WriteAddr>=(STM32_FLASH_BASE+1024*STM32_FLASH_SIZE)))return;//Ƿַ
	STMFLASH_Unlock();						//
	offaddr=WriteAddr-STM32_FLASH_BASE;		//ʵƫƵַ.
	secpos=offaddr/STM_SECTOR_SIZE;			//ַ  0~127 for STM32F103RBT6
	secoff=(offaddr%STM_SECTOR_SIZE)/2;		//ڵƫ(2ֽΪλ.)
	secremain=STM_SECTOR_SIZE/2-secoff;		//ʣռС   
	if(NumToWrite<=secremain)secremain=NumToWrite;//ڸΧ
	while(1) 
	{	
		STMFLASH_Read(secpos*STM_SECTOR_SIZE+STM32_FLASH_BASE,STMFLASH_BUF,STM_SECTOR_SIZE/2);//
		for(i=0;i<secremain;i++)//У
		{
			if(STMFLASH_BUF[secoff+i]!=0XFFFF)break;//Ҫ  	  
		}
		if(i<secremain)//Ҫ
		{
			STMFLASH_ErasePage(secpos*STM_SECTOR_SIZE+STM32_FLASH_BASE);//
			for(i=0;i<secremain;i++)//
			{
				STMFLASH_BUF[i+secoff]=pBuffer[i];	  
			}
			STMFLASH_Write_NoCheck(secpos*STM_SECTOR_SIZE+STM32_FLASH_BASE,STMFLASH_BUF,STM_SECTOR_SIZE/2);//д  
		}else STMFLASH_Write_NoCheck(WriteAddr,pBuffer,secremain);//дѾ˵,ֱдʣ. 				   
		if(NumToWrite==secremain)break;//д
		else//дδ
		{
			secpos++;				//ַ1
			secoff=0;				//ƫλΪ0 	 
		   	pBuffer+=secremain;  	//ָƫ
			WriteAddr+=secremain*2;	//дַƫ(16λݵַ,Ҫ*2)	   
		   	NumToWrite-=secremain;	//ֽ(16λ)ݼ
			if(NumToWrite>(STM_SECTOR_SIZE/2))secremain=STM_SECTOR_SIZE/2;//һд
			else secremain=NumToWrite;//һд
		}	 
	};	
	STMFLASH_Lock();//
}
#endif
//ַָʼָȵ
//ReadAddr:ʼַ
//pBuffer:ָ
//NumToWrite:(16λ)
void STMFLASH_Read(u32 ReadAddr,u16 *pBuffer,u16 NumToRead)   	
{
	u16 i;
	for(i=0;i<NumToRead;i++)
	{
		pBuffer[i]=STMFLASH_ReadHalfWord(ReadAddr);//ȡ2ֽ.
		ReadAddr+=2;//ƫ2ֽ.	
	}
}

/////////////////////////////////////////////////////////////////////////////////////
//WriteAddr:ʼַ
//WriteData:Ҫд
void Test_Write(u32 WriteAddr,u16 WriteData)   	
{
	STMFLASH_Write(WriteAddr,&WriteData,1);//дһ 
}
 
/**************************************************************************
ܣFlashȡָ
ڲ
  ֵ
**************************************************************************/
void Flash_Read(void)
{
	STMFLASH_Read(FLASH_SAVE_ADDR,(u16*)PID_Parameter,10);
	if(PID_Parameter[0]==65535&&PID_Parameter[1]==65535&&PID_Parameter[2]==65535&&PID_Parameter[3]==65535)
	{
	Bluetooth_Velocity=30;
	Velocity_KP=12;
	Velocity_KI=12;
	}
  else
	{		
	Bluetooth_Velocity=(float)PID_Parameter[0];
	Velocity_KP=(float)PID_Parameter[1];
	Velocity_KI=(float)PID_Parameter[2];
	}
}	
/**************************************************************************
ܣFlashдָ
ڲ
  ֵ
**************************************************************************/
void Flash_Write(void)
{
Flash_Parameter[0]=Bluetooth_Velocity;	//Ŵ100洢ָ	
Flash_Parameter[1]=Velocity_KP;	//Ŵ100洢ָ	
Flash_Parameter[2]=Velocity_KI;	//Ŵ100洢ָ	
STMFLASH_Write(FLASH_SAVE_ADDR,(u16*)Flash_Parameter,10);	
}	



